(function ($) {
    ("use strict");

    $(document).ready(function () {
        dataTable('all');
    });

    $(document).on('click', '.ticketStatusTab', function (e) {
        var status = $(this).data('status');
        dataTable(status);
    });

    var allTeamTable
    $(document).on('input', '#datatableSearch', function () {
        allTeamTable.search($(this).val()).draw();
    });

    function dataTable(status) {

        allTeamTable = $("#ticketTable-" + status).DataTable({
            pageLength: 10,
            ordering: false,
            serverSide: false,
            processing: true,
            responsive: true,
            searching: true,
            language: {
                paginate: {
                    previous: "<i class='fa-solid fa-angles-left'></i>",
                    next: "<i class='fa-solid fa-angles-right'></i>",
                },
                searchPlaceholder: "Search event",
                search: "<span class='searchIcon'><i class='fa-solid fa-magnifying-glass'></i></span>",
            },
            ajax: {
                url: $('#ticketListRoute').val(),
                data: function (data) {
                    data.status = status;
                }
            },
            dom: '<>tr<"tableBottom"<"row align-items-center"<"col-sm-6"<"tableInfo"i>><"col-sm-6"<"tablePagi"p>>>><"clear">',
            columns: [
                {"data": "ticket_id", "name": "ticket.ticket_id"},
                {"data": "order_id", "name": "ticket.order_id"},
                {"data": "client"},
                {"data": "priority"},
                {"data": "assignee"},
                {"data": "status"},
                {"data": "action"}
            ],
            stateSave: true,
            "bDestroy": true
        });
    }

    $(document).on('click', '.assign-member', function (e) {
        var checkedStatus = $(this).prop('checked') ? 1 : 0;

        commonAjax('GET', $('#assignMemberRoute').val(), function(response) {
            if (response['status'] === true) {
                toastr.success(response['message']);
            } else {
                commonHandler(response);
            }
            setTimeout(() => {
                location.reload();
            }, 1000);
        }, function(error) {
            console.error('Error:', error);
            setTimeout(() => {
                location.reload();
            }, 1000);
        }, {
            'member_id': $(this).val(),
            'checked_status': checkedStatus,
            'ticket_id': $(this).data('ticket'),
            'data_table': $(this).data('table')
        });
    });


    function assigneeResponse(response) {
        $('.error-message').remove();
        $('.is-invalid').removeClass('is-invalid');
        if (response['status'] === true) {
            toastr.success(response['message']);
            $('#ticketTable-' + response.data.datatable).DataTable().ajax.reload();
        } else {
            commonHandler(response)
        }
    }

    $(document).on('click', '.file-delete', function (e) {
        $(this).parent().remove();
    });

    $(document).on('click', '.ticket-status-change', function (e) {
        Swal.fire({
            title: 'Sure! You want to change status?',
            text: "You Are Going To Change Ticket Status!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Change It!'
        }).then((result) => {
            if (result.value) {
                commonAjax('GET', $('#statusChangeRoute').val(), statusChangeResponse, statusChangeResponse, {
                    'status': $(this).val(),
                    'ticket_id': $(this).data('ticket'),
                });
            }else{
                $(".status"+$(this).data('status')).prop("checked", true);
            }
        })


    });

    function statusChangeResponse(response){
        if (response['status'] === true) {
            toastr.success(response['message']);
        } else {
            commonHandler(response)
        }
    }


})(jQuery);
