<!-- Sidebar -->
<div data-aos="fade-right" data-aos-duration="1000" class="zSidebar">
    <div class="zSidebar-overlay"></div>
    <div class="zSidebar-wrap h-100">
        <!-- Logo -->
        <a href="{{ route('admin.dashboard') }}" class="zSidebar-logo">
            <img class="max-h-35" src="{{ getSettingImage('app_logo_white') }}" alt=""/></a>
        <!-- Menu & Logout -->
        <div class="zSidebar-fixed">
            <ul class="zSidebar-menu" id="sidebarMenu">
                <li class="sidebar-divider">
                    <p class="fs-10 fw-600 lh-12 text-frame">{{ __('MAIN') }}</p>
                    <div class="d-flex"><img src="{{ asset('assets/images/icon/double-angle-right.svg') }}"
                                             alt=""/></div>
                </li>
                <li>
                    <a href="{{ route('admin.dashboard') }}"
                       class="d-flex align-items-center cg-10 {{ @$activeDashboard }}">
                        <div class="d-flex">
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M6.85714 3.42857C6.85714 5.32212 5.32212 6.85714 3.42857 6.85714C1.53502 6.85714 0 5.32212 0 3.42857C0 1.53502 1.53502 0 3.42857 0C5.32212 0 6.85714 1.53502 6.85714 3.42857ZM16 3.42857C16 5.32212 14.465 6.85714 12.5714 6.85714C10.6779 6.85714 9.14286 5.32212 9.14286 3.42857C9.14286 1.53502 10.6779 0 12.5714 0C14.465 0 16 1.53502 16 3.42857ZM3.42857 16C5.32212 16 6.85714 14.465 6.85714 12.5714C6.85714 10.6779 5.32212 9.14286 3.42857 9.14286C1.53502 9.14286 0 10.6779 0 12.5714C0 14.465 1.53502 16 3.42857 16ZM16 12.5714C16 14.465 14.465 16 12.5714 16C10.6779 16 9.14286 14.465 9.14286 12.5714C9.14286 10.6779 10.6779 9.14286 12.5714 9.14286C14.465 9.14286 16 10.6779 16 12.5714Z"
                                      fill="#5D697A"/>
                            </svg>
                        </div>
                        <span class="">{{ __('Dashboard') }}</span>
                    </a>
                </li>
                @can('Manage Client')
                    <li>
                        <a href="{{ route('admin.client.list') }}"
                           class="d-flex align-items-center cg-10 {{ @$activeClientIndex }}">
                            <div class="d-flex">
                                <svg width="16" height="15" viewBox="0 0 16 15" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M9.14286 3.42857C9.14286 5.32212 7.60783 6.85714 5.71429 6.85714C3.82074 6.85714 2.28571 5.32212 2.28571 3.42857C2.28571 1.53502 3.82074 0 5.71429 0C7.60783 0 9.14286 1.53502 9.14286 3.42857ZM5.71429 7.99996C2.55837 7.99996 0 10.5583 0 13.7142C0 14.0298 0.255837 14.2857 0.571429 14.2857H10.8571C11.1727 14.2857 11.4286 14.0298 11.4286 13.7142C11.4286 10.5583 8.8702 7.99996 5.71429 7.99996ZM15.4287 14.2857H12.7744C12.8283 14.1046 12.8572 13.9128 12.8572 13.7143C12.8572 11.3816 11.7391 9.31011 10.0095 8.00653C10.1011 8.00217 10.1932 7.99997 10.2858 7.99997C13.4417 7.99997 16.0001 10.5583 16.0001 13.7143C16.0001 14.0298 15.7443 14.2857 15.4287 14.2857ZM10.2858 6.85714C9.94097 6.85714 9.60803 6.80624 9.29408 6.71153C10.0873 5.84703 10.5715 4.69434 10.5715 3.42857C10.5715 2.1628 10.0873 1.01011 9.29408 0.145615C9.60803 0.0509069 9.94097 0 10.2858 0C12.1793 0 13.7144 1.53502 13.7144 3.42857C13.7144 5.32212 12.1793 6.85714 10.2858 6.85714Z"
                                          fill="#5D697A"/>
                                </svg>
                            </div>
                            <span class="">{{ __('Clients') }}</span>
                        </a>
                    </li>
                @endcan
                @can('Manage Orders')
                    <li>
                        <a href="{{ route('admin.client-orders.list') }}"
                           class="d-flex align-items-center cg-10 {{ @$activeClientOrderIndex }}">
                            <div class="d-flex">
                                <svg width="14" height="17" viewBox="0 0 14 17" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M0.585786 0.585786C0 1.17157 0 2.11438 0 4V12.2917C0 14.1773 0 15.1201 0.585786 15.7059C1.17157 16.2917 2.11438 16.2917 4 16.2917H9.41667C11.3023 16.2917 12.2451 16.2917 12.8309 15.7059C13.4167 15.1201 13.4167 14.1773 13.4167 12.2917V4C13.4167 2.11438 13.4167 1.17157 12.8309 0.585786C12.2451 0 11.3023 0 9.41666 0H4C2.11438 0 1.17157 0 0.585786 0.585786ZM3.83333 3.79167C3.28105 3.79167 2.83333 4.23938 2.83333 4.79167C2.83333 5.34395 3.28105 5.79167 3.83333 5.79167H9.58333C10.1356 5.79167 10.5833 5.34395 10.5833 4.79167C10.5833 4.23938 10.1356 3.79167 9.58333 3.79167H3.83333ZM3.83333 7.625C3.28105 7.625 2.83333 8.07271 2.83333 8.625C2.83333 9.17728 3.28105 9.625 3.83333 9.625H9.58333C10.1356 9.625 10.5833 9.17728 10.5833 8.625C10.5833 8.07271 10.1356 7.625 9.58333 7.625H3.83333ZM3.83333 11.4583C3.28105 11.4583 2.83333 11.906 2.83333 12.4583C2.83333 13.0106 3.28105 13.4583 3.83333 13.4583H7.66667C8.21895 13.4583 8.66667 13.0106 8.66667 12.4583C8.66667 11.906 8.21895 11.4583 7.66667 11.4583H3.83333Z"
                                          fill="#5D697A"/>
                                </svg>
                            </div>
                            <span class="">{{ __('Orders') }}</span>
                        </a>
                    </li>
                @endcan
                @can('Manage Invoice')
                    <li>
                        <a href="{{ route('admin.client-invoice.list') }}"
                           class="d-flex align-items-center cg-10 {{ @$activeClientInvoiceIndex }}">
                            <div class="d-flex">
                                <svg width="13" height="17" viewBox="0 0 13 17" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M4.75 0C3.09315 0 1.75 1.34315 1.75 3L1.75003 3.01326C1.27133 3.03607 0.956202 3.09811 0.70368 3.26684C0.530796 3.38236 0.382357 3.5308 0.26684 3.70368C0 4.10303 0 4.65897 0 5.77083V13.2917C0 14.7844 0 15.5308 0.463748 15.9946C0.927495 16.4583 1.67389 16.4583 3.16667 16.4583H9.5C10.9928 16.4583 11.7392 16.4583 12.2029 15.9946C12.6667 15.5308 12.6667 14.7844 12.6667 13.2917V5.77083C12.6667 4.65897 12.6667 4.10303 12.3998 3.70368C12.2843 3.5308 12.1359 3.38236 11.963 3.26684C11.7105 3.09811 11.3953 3.03607 10.9166 3.01326L10.9167 3C10.9167 1.34315 9.57352 0 7.91667 0H4.75ZM4.54167 3C4.54167 2.44772 4.98938 2 5.54167 2H7.125C7.67728 2 8.125 2.44772 8.125 3C8.125 3.55228 7.67728 4 7.125 4H5.54167C4.98938 4 4.54167 3.55228 4.54167 3ZM3.95833 7.54167C3.40605 7.54167 2.95833 7.98938 2.95833 8.54167C2.95833 9.09395 3.40605 9.54167 3.95833 9.54167H8.70833C9.26062 9.54167 9.70833 9.09395 9.70833 8.54167C9.70833 7.98938 9.26062 7.54167 8.70833 7.54167H3.95833ZM3.95833 10.7083C3.40605 10.7083 2.95833 11.156 2.95833 11.7083C2.95833 12.2606 3.40605 12.7083 3.95833 12.7083L7.125 12.7083C7.67728 12.7083 8.125 12.2606 8.125 11.7083C8.125 11.156 7.67728 10.7083 7.125 10.7083L3.95833 10.7083Z"
                                          fill="#5D697A"/>
                                </svg>
                            </div>
                            <span class="">{{ __('Invoice') }}</span>
                        </a>
                    </li>
                @endcan
                @can('Manage Tickets')
                    <li>
                        <a href="{{ route('admin.ticket.list') }}"
                           class="d-flex align-items-center cg-10 {{ @$activeTicket }}">
                            <div class="d-flex">
                                <svg width="19" height="15" viewBox="0 0 19 15" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M11.0085 13.7527L11.014 11.9167C11.014 11.6729 11.1108 11.4392 11.2831 11.2669C11.4555 11.0945 11.6892 10.9977 11.9329 10.9977C12.1766 10.9977 12.4104 11.0945 12.5827 11.2669C12.7551 11.4392 12.8519 11.6729 12.8519 11.9167V13.7289C12.8519 14.1698 12.8519 14.3907 12.993 14.5264C13.1351 14.6612 13.3505 14.652 13.7841 14.6337C15.4919 14.5613 16.5415 14.3312 17.2803 13.5923C18.0228 12.8535 18.2529 11.8039 18.3253 10.0934C18.339 9.75425 18.3464 9.58375 18.2831 9.471C18.219 9.35825 17.9669 9.21708 17.4609 8.93383C17.1759 8.77493 16.9384 8.5428 16.7732 8.26143C16.6079 7.98006 16.5207 7.65966 16.5207 7.33333C16.5207 7.00701 16.6079 6.68661 16.7732 6.40523C16.9384 6.12386 17.1759 5.89173 17.4609 5.73283C17.9669 5.4505 18.2199 5.30842 18.2831 5.19567C18.3464 5.08292 18.339 4.91333 18.3244 4.57325C18.2529 2.86275 18.0219 1.81408 17.2803 1.07433C16.4764 0.271333 15.3049 0.06875 13.3185 0.0174167C13.2576 0.0158252 13.1971 0.0264332 13.1405 0.0486148C13.0838 0.0707964 13.0322 0.104102 12.9886 0.146566C12.945 0.189031 12.9104 0.239793 12.8867 0.295859C12.8631 0.351924 12.8509 0.412156 12.851 0.473V2.75C12.851 2.99372 12.7541 3.22746 12.5818 3.3998C12.4095 3.57214 12.1757 3.66896 11.932 3.66896C11.6883 3.66896 11.4545 3.57214 11.2822 3.3998C11.1099 3.22746 11.013 2.99372 11.013 2.75L11.0066 0.457417C11.0064 0.336018 10.958 0.219674 10.8721 0.133918C10.7861 0.0481625 10.6697 -2.42797e-07 10.5483 0H7.32896C3.86396 0 2.13146 -1.09275e-07 1.05438 1.07433C0.311878 1.81317 0.0817948 2.86275 0.00937811 4.57325C-0.00437189 4.91242 -0.0117052 5.08292 0.0515448 5.19567C0.115711 5.30842 0.367795 5.4505 0.873795 5.73283C1.15882 5.89173 1.39624 6.12386 1.56152 6.40523C1.7268 6.68661 1.81394 7.00701 1.81394 7.33333C1.81394 7.65966 1.7268 7.98006 1.56152 8.26143C1.39624 8.5428 1.15882 8.77493 0.873795 8.93383C0.367795 9.21708 0.114795 9.35825 0.0515448 9.471C-0.0117052 9.58375 -0.00437196 9.75333 0.0102947 10.0925C0.0817947 11.8039 0.312795 12.8535 1.05438 13.5923C2.13146 14.6667 3.86396 14.6667 7.32988 14.6667H10.089C10.5217 14.6667 10.7371 14.6667 10.8719 14.5328C11.0066 14.399 11.0075 14.1845 11.0085 13.7527ZM12.851 8.25V6.41667C12.851 6.17294 12.7541 5.9392 12.5818 5.76686C12.4095 5.59453 12.1757 5.49771 11.932 5.49771C11.6883 5.49771 11.4545 5.59453 11.2822 5.76686C11.1099 5.9392 11.013 6.17294 11.013 6.41667V8.25C11.013 8.49384 11.1099 8.7277 11.2823 8.90013C11.4548 9.07255 11.6886 9.16942 11.9325 9.16942C12.1763 9.16942 12.4102 9.07255 12.5826 8.90013C12.755 8.7277 12.851 8.49384 12.851 8.25Z"
                                          fill="#5D697A"/>
                                </svg>
                            </div>
                            <span class="">{{ __('Tickets') }}</span>
                        </a>
                    </li>
                @endcan
                @can('Manage Team Member')
                    <li>
                        <a href="{{ route('admin.team-member.index') }}"
                           class="d-flex align-items-center cg-10 {{ @$activeTeamMember }}">
                            <div class="d-flex">
                                <svg width="19" height="15" viewBox="0 0 19 15" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M2.85 6.375C3.89797 6.375 4.75 5.42207 4.75 4.25C4.75 3.07793 3.89797 2.125 2.85 2.125C1.80203 2.125 0.95 3.07793 0.95 4.25C0.95 5.42207 1.80203 6.375 2.85 6.375ZM16.15 6.375C17.198 6.375 18.05 5.42207 18.05 4.25C18.05 3.07793 17.198 2.125 16.15 2.125C15.102 2.125 14.25 3.07793 14.25 4.25C14.25 5.42207 15.102 6.375 16.15 6.375ZM17.1 7.4375H15.2C14.6775 7.4375 14.2055 7.67324 13.8611 8.05508C15.0575 8.78887 15.9066 10.1137 16.0906 11.6875H18.05C18.5755 11.6875 19 11.2127 19 10.625V9.5625C19 8.39043 18.148 7.4375 17.1 7.4375ZM9.5 7.4375C11.3377 7.4375 12.825 5.77402 12.825 3.71875C12.825 1.66348 11.3377 0 9.5 0C7.66234 0 6.175 1.66348 6.175 3.71875C6.175 5.77402 7.66234 7.4375 9.5 7.4375ZM11.78 8.5H11.5336C10.9161 8.83203 10.2303 9.03125 9.5 9.03125C8.76969 9.03125 8.08687 8.83203 7.46641 8.5H7.22C5.33187 8.5 3.8 10.2133 3.8 12.325V13.2812C3.8 14.1611 4.43828 14.875 5.225 14.875H13.775C14.5617 14.875 15.2 14.1611 15.2 13.2812V12.325C15.2 10.2133 13.6681 8.5 11.78 8.5ZM5.13891 8.05508C4.79453 7.67324 4.3225 7.4375 3.8 7.4375H1.9C0.852031 7.4375 0 8.39043 0 9.5625V10.625C0 11.2127 0.424531 11.6875 0.95 11.6875H2.90641C3.09344 10.1137 3.9425 8.78887 5.13891 8.05508Z"
                                        fill="#5D697A"/>
                                </svg>
                            </div>
                            <span class="">{{ __('Team Members') }}</span>
                        </a>
                    </li>
                @endcan
                @canany(['Manage Services','Manage Packages'])
                    <li class="sidebar-divider">
                        <p class="fs-10 fw-600 lh-12 text-frame">{{ __('SETUP') }}</p>
                        <div class="d-flex"><img src="{{ asset('assets/images/icon/double-angle-right.svg') }}"
                                                 alt=""/></div>
                    </li>
                @endcanany
                @can('Manage Packages')
                    <li>
                        <a href="{{ route('admin.packages.index') }}"
                           class="d-flex align-items-center cg-10 {{ @$activePackage }}">
                            <div class="d-flex">
                                <svg width="23" height="23" viewBox="0 0 23 23" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M4.90667 4.79167H18.0838L17.1829 3.83333H5.68292L4.90667 4.79167ZM19.6842 5.01208C19.9621 5.33792 20.125 5.75 20.125 6.22917V18.2083C20.125 18.7167 19.9231 19.2042 19.5636 19.5636C19.2042 19.9231 18.7167 20.125 18.2083 20.125H4.79167C4.28333 20.125 3.79582 19.9231 3.43638 19.5636C3.07693 19.2042 2.875 18.7167 2.875 18.2083V6.22917C2.875 5.75 3.03792 5.33792 3.31583 5.01208L4.63833 3.40208C4.90667 3.07625 5.29958 2.875 5.75 2.875H17.25C17.7004 2.875 18.0933 3.07625 18.3521 3.40208L19.6842 5.01208ZM5.75 17.25H11.5V14.375H5.75V17.25Z"
                                        fill="white"/>
                                </svg>
                            </div>
                            <span class="">{{ __('Package') }}</span>
                        </a>
                    </li>
                @endcan
                @can('Manage Services')
                    <li>
                        <a href="{{ route('admin.services.index') }}"
                           class="d-flex align-items-center cg-10 {{ @$activeService }}">
                            <div class="d-flex">
                                <svg width="23" height="23" viewBox="0 0 23 23" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M3.83334 19.1667C3.30626 19.1667 2.8552 18.9792 2.48017 18.6041C2.10514 18.2291 1.91731 17.7777 1.91667 17.25V13.4167H6.70834C6.70834 13.6882 6.80034 13.916 6.98434 14.1C7.16834 14.284 7.39578 14.3756 7.66667 14.375C7.92223 14.375 8.10207 14.259 8.20621 14.0271C8.31035 13.7952 8.44995 13.5917 8.625 13.4167H14.375C14.375 13.6882 14.467 13.916 14.651 14.1C14.835 14.284 15.0624 14.3756 15.3333 14.375C15.5889 14.375 15.7687 14.259 15.8729 14.0271C15.977 13.7952 16.1166 13.5917 16.2917 13.4167H21.0833V17.25C21.0833 17.7771 20.8958 18.2285 20.5208 18.6041C20.1458 18.9798 19.6944 19.1673 19.1667 19.1667H3.83334ZM2.32396 11.5L4.31251 6.9C4.45625 6.54861 4.68785 6.2691 5.0073 6.06146C5.32674 5.85382 5.67014 5.75 6.03751 5.75H6.70834V4.79167C6.70834 4.26458 6.89617 3.81321 7.27184 3.43754C7.6475 3.06188 8.09856 2.87436 8.625 2.875H14.375C14.9021 2.875 15.3535 3.06283 15.7291 3.4385C16.1048 3.81417 16.2923 4.26522 16.2917 4.79167V5.75H16.9625C17.3299 5.75 17.6733 5.85382 17.9927 6.06146C18.3122 6.2691 18.5438 6.54861 18.6875 6.9L20.676 11.5H16.2917C16.2917 11.2285 16.1997 11.001 16.0157 10.8177C15.8317 10.6343 15.6042 10.5423 15.3333 10.5417C15.0778 10.5417 14.8983 10.6576 14.7948 10.8895C14.6913 11.1215 14.5513 11.3249 14.375 11.5H8.625C8.625 11.2285 8.533 11.001 8.349 10.8177C8.165 10.6343 7.93756 10.5423 7.66667 10.5417C7.41112 10.5417 7.23159 10.6576 7.12809 10.8895C7.02459 11.1215 6.88467 11.3249 6.70834 11.5H2.32396ZM8.625 5.75H14.375V4.79167H8.625V5.75Z"
                                        fill="white"/>
                                </svg>
                            </div>
                            <span class="">{{ __('Services') }}</span>
                        </a>
                    </li>
                @endcan
                <li class="sidebar-divider">
                    <p class="fs-10 fw-600 lh-12 text-frame">{{ __('OTHERS') }}</p>
                    <div class="d-flex"><img src="{{ asset('assets') }}/images/icon/double-angle-right.svg"
                                             alt=""/></div>
                </li>
                <li>
                    <a href="{{ route('admin.setting.profile.index') }}"
                       class="d-flex align-items-center cg-10 {{ @$activeSetting }}">
                        <div class="d-flex">
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M9.56527 0.757929C9.58283 0.828314 9.59114 0.911478 9.60778 1.07781C9.63919 1.39198 9.6549 1.54907 9.68762 1.65049C9.87683 2.23715 10.5466 2.51458 11.0952 2.23355C11.1901 2.18497 11.3123 2.085 11.5566 1.88506C11.686 1.77922 11.7507 1.72629 11.8129 1.68894C12.1607 1.48005 12.6002 1.50197 12.9254 1.74443C12.9836 1.78779 13.0427 1.84688 13.1609 1.96507L13.8682 2.6724C13.9864 2.7906 14.0455 2.8497 14.0889 2.90786C14.3313 3.23313 14.3533 3.67264 14.1444 4.02042C14.107 4.0826 14.0541 4.14729 13.9482 4.27666C13.7483 4.52104 13.6483 4.64323 13.5997 4.73809C13.3187 5.28671 13.5961 5.95648 14.1828 6.14571C14.2842 6.17842 14.4413 6.19413 14.7555 6.22555L14.7555 6.22555L14.7555 6.22555C14.9219 6.24219 15.005 6.2505 15.0754 6.26807C15.469 6.36627 15.7643 6.69255 15.8229 7.09398C15.8333 7.16577 15.8333 7.24936 15.8333 7.41653V8.4169C15.8333 8.58398 15.8333 8.66752 15.8229 8.73927C15.7643 9.14077 15.469 9.4671 15.0753 9.56529C15.005 9.58284 14.9219 9.59115 14.7556 9.60777L14.7556 9.60778C14.4416 9.63918 14.2846 9.65487 14.1832 9.68755C13.5964 9.87672 13.3189 10.5467 13.6001 11.0954C13.6487 11.1901 13.7486 11.3122 13.9484 11.5564C14.0541 11.6857 14.107 11.7503 14.1443 11.8125C14.3533 12.1603 14.3314 12.5999 14.0888 12.9252C14.0455 12.9833 13.9865 13.0424 13.8684 13.1605L13.1609 13.8679C13.0427 13.9861 12.9836 14.0452 12.9255 14.0886C12.6002 14.331 12.1607 14.3529 11.8129 14.144C11.7507 14.1067 11.686 14.0538 11.5567 13.9479C11.3123 13.748 11.1901 13.648 11.0953 13.5994C10.5467 13.3184 9.87687 13.5958 9.68765 14.1825C9.65494 14.2839 9.63922 14.441 9.6078 14.7553L9.6078 14.7553C9.59115 14.9218 9.58282 15.0051 9.56524 15.0755C9.46702 15.469 9.14079 15.7643 8.73943 15.8228C8.6676 15.8333 8.58397 15.8333 8.4167 15.8333H7.41652C7.24935 15.8333 7.16577 15.8333 7.09398 15.8229C6.69255 15.7643 6.36627 15.469 6.26806 15.0754C6.2505 15.005 6.24218 14.9219 6.22555 14.7555L6.22555 14.7555L6.22555 14.7555C6.19413 14.4413 6.17842 14.2842 6.1457 14.1828C5.95647 13.5961 5.28671 13.3187 4.73809 13.5997C4.64323 13.6483 4.52104 13.7483 4.27664 13.9483L4.27663 13.9483C4.14725 14.0541 4.08256 14.1071 4.02037 14.1444C3.6726 14.3533 3.23309 14.3314 2.90784 14.0889C2.84967 14.0456 2.79057 13.9865 2.67236 13.8683L2.67235 13.8682L1.96505 13.1609L1.96503 13.1609C1.84684 13.0427 1.78774 12.9836 1.74439 12.9255C1.50193 12.6002 1.48001 12.1607 1.6889 11.8129C1.72625 11.7507 1.77917 11.6861 1.88502 11.5567L1.88504 11.5567C2.08498 11.3123 2.18496 11.1901 2.23354 11.0952C2.51457 10.5466 2.23714 9.87684 1.65048 9.68762C1.54906 9.65491 1.39197 9.6392 1.0778 9.60778L1.07778 9.60778C0.911469 9.59115 0.828312 9.58283 0.757931 9.56527C0.364306 9.46707 0.0690197 9.14078 0.0104693 8.73934C0 8.66755 0 8.58398 0 8.41683V7.41661C0 7.24936 0 7.16574 0.0104808 7.09392C0.0690547 6.69254 0.364294 6.3663 0.757855 6.26808C0.828276 6.25051 0.911482 6.24219 1.0779 6.22554C1.39224 6.19411 1.54942 6.17839 1.65089 6.14565C2.23744 5.95639 2.51482 5.28674 2.23389 4.73816C2.18529 4.64325 2.08525 4.52098 1.88517 4.27644L1.88517 4.27644C1.77922 4.14695 1.72625 4.0822 1.68888 4.01996C1.48007 3.67223 1.50198 3.23282 1.74436 2.9076C1.78774 2.84938 1.84688 2.79024 1.96518 2.67195L1.96518 2.67195L2.67239 1.96473L2.67239 1.96473C2.7906 1.84652 2.8497 1.78742 2.90787 1.74406C3.23313 1.50161 3.67263 1.47969 4.0204 1.68857C4.0826 1.72593 4.14731 1.77888 4.27673 1.88477C4.52106 2.08467 4.64322 2.18462 4.73801 2.23319C5.28669 2.51433 5.9566 2.23684 6.14578 1.65007C6.17846 1.5487 6.19416 1.3917 6.22556 1.07771L6.22556 1.0777L6.22556 1.07769C6.24218 0.911467 6.25049 0.828354 6.26804 0.75801C6.36623 0.36432 6.69257 0.0689842 7.09407 0.0104577C7.16582 0 7.24935 0 7.4164 0H8.41682C8.58397 0 8.66755 0 8.73933 0.0104697C9.14077 0.0690208 9.46706 0.364306 9.56527 0.757929ZM7.91666 11.0833C9.66556 11.0833 11.0833 9.66557 11.0833 7.91667C11.0833 6.16776 9.66556 4.75 7.91666 4.75C6.16776 4.75 4.75 6.16776 4.75 7.91667C4.75 9.66557 6.16776 11.0833 7.91666 11.0833Z"
                                      fill="#5D697A"/>
                            </svg>
                        </div>
                        <span class="">{{ __('Settings') }}</span>
                    </a>
                </li>
                @can('Manage Cms Settings')
                    <li>
                        <a href="{{ route('admin.theme-settings.index') }}"
                           class="d-flex align-items-center cg-10 {{ @$activeThemeSettingsIndex }}">
                            <div class="d-flex">
                                <svg width="23" height="23" viewBox="0 0 23 23" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M13.5796 13.1387L14.9212 10.8195C15.0075 10.6758 14.9692 10.4937 14.8446 10.3883L13.4262 9.27663C13.455 9.06579 13.4742 8.84538 13.4742 8.62496C13.4742 8.40454 13.455 8.18413 13.4262 7.96371L14.8446 6.85204C14.9692 6.74663 15.0075 6.56454 14.9212 6.42079L13.5796 4.10163C13.4933 3.95788 13.3208 3.90038 13.1675 3.95788L11.5 4.62871C11.155 4.36038 10.7812 4.13996 10.3692 3.96746L10.12 2.19454C10.1039 2.11703 10.0619 2.0473 10.001 1.9968C9.94004 1.94629 9.86372 1.91802 9.78458 1.91663H7.10124C6.93833 1.91663 6.79458 2.04121 6.76583 2.20413L6.51666 3.97704C6.11416 4.14954 5.73083 4.36996 5.38583 4.63829L3.71833 3.96746C3.56499 3.90996 3.39249 3.96746 3.30624 4.11121L1.96458 6.43038C1.87833 6.57413 1.91666 6.75621 2.04124 6.86163L3.45958 7.97329C3.43083 8.18413 3.41166 8.40454 3.41166 8.62496C3.41166 8.84538 3.43083 9.06579 3.45958 9.28621L2.04124 10.3979C1.91666 10.5033 1.87833 10.6854 1.96458 10.8291L3.30624 13.1483C3.39249 13.292 3.56499 13.3495 3.71833 13.292L5.38583 12.6212C5.73083 12.8895 6.10458 13.11 6.51666 13.2825L6.76583 15.0554C6.79458 15.2087 6.93833 15.3333 7.10124 15.3333H9.78458C9.94749 15.3333 10.0912 15.2087 10.12 15.0458L10.3692 13.2729C10.7717 13.1004 11.155 12.88 11.5 12.6116L13.1675 13.2825C13.3208 13.34 13.4933 13.2825 13.5796 13.1387ZM8.44291 10.5416C7.38874 10.5416 6.52624 9.67913 6.52624 8.62496C6.52624 7.57079 7.38874 6.70829 8.44291 6.70829C9.49708 6.70829 10.3596 7.57079 10.3596 8.62496C10.3596 9.67913 9.49708 10.5416 8.44291 10.5416ZM21.0067 17.892L20.0867 17.1829C20.1058 17.0487 20.125 16.905 20.125 16.7612C20.125 16.6175 20.1154 16.4737 20.0867 16.3395L20.9971 15.6304C21.0737 15.5633 21.1025 15.4483 21.045 15.3525L20.1825 13.867C20.1346 13.7712 20.0196 13.7425 19.9142 13.7712L18.8504 14.2025C18.63 14.03 18.3904 13.8862 18.1221 13.7808L17.9592 12.65C17.9554 12.5987 17.9327 12.5508 17.8955 12.5153C17.8583 12.4799 17.8093 12.4596 17.7579 12.4583H16.0425C15.9371 12.4583 15.8412 12.535 15.8317 12.6404L15.6687 13.7712C15.41 13.8862 15.1608 14.0204 14.9404 14.1929L13.8767 13.7616C13.8278 13.7433 13.7741 13.7428 13.7249 13.7604C13.6758 13.7779 13.6345 13.8123 13.6083 13.8575L12.7458 15.3429C12.6979 15.4387 12.7075 15.5537 12.7937 15.6208L13.7042 16.33C13.6653 16.6097 13.6653 16.8935 13.7042 17.1733L12.7937 17.8825C12.7171 17.9495 12.6883 18.0645 12.7458 18.1604L13.6083 19.6458C13.6562 19.7416 13.7712 19.7704 13.8767 19.7416L14.9404 19.3104C15.1608 19.4829 15.4004 19.6266 15.6687 19.732L15.8317 20.8629C15.8508 20.9683 15.9371 21.045 16.0425 21.045H17.7579C17.8633 21.045 17.9592 20.9683 17.9687 20.8629L18.1317 19.732C18.3904 19.617 18.6396 19.4829 18.8504 19.3104L19.9237 19.7416C20.0196 19.78 20.1346 19.7416 20.1921 19.6458L21.0546 18.1604C21.1121 18.0741 21.0833 17.9591 21.0067 17.892ZM16.8954 18.0454C16.7254 18.0453 16.5572 18.0118 16.4002 17.9467C16.2432 17.8816 16.1005 17.7862 15.9804 17.666C15.8603 17.5457 15.765 17.403 15.7 17.246C15.635 17.0889 15.6016 16.9206 15.6017 16.7507C15.6017 16.5807 15.6353 16.4124 15.7004 16.2554C15.7655 16.0984 15.8608 15.9558 15.9811 15.8356C16.1013 15.7155 16.244 15.6202 16.401 15.5553C16.5581 15.4903 16.7264 15.4569 16.8964 15.4569C17.2396 15.457 17.5688 15.5935 17.8114 15.8363C18.054 16.0791 18.1902 16.4084 18.1901 16.7516C18.19 17.0949 18.0535 17.424 17.8107 17.6666C17.5679 17.9093 17.2387 18.0455 16.8954 18.0454Z"
                                        fill="white"/>
                                </svg>
                            </div>
                            <span class="">{{ __('Theme Settings') }}</span>
                        </a>
                    </li>
                    <li>
                        <a href="#"
                           class="d-flex align-items-center cg-10 {{isset($showManageBlog) ? 'collapsed active' : ''}}"
                           data-bs-toggle="collapse" data-bs-target="#collapseBlog"
                           aria-expanded="{{isset($showManageBlog) ? 'true' : 'false'}}" aria-controls="collapseBlog">
                            <div class="d-flex">
                                <svg width="23" height="23" viewBox="0 0 23 23" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M19.4235 1.38001L21.045 3.00151C21.4935 3.45001 21.4935 4.17451 21.045 4.62301L16.1 9.57951V19.2C16.1 20.0284 15.4284 20.7 14.6 20.7H4.95C4.12157 20.7 3.45 20.0284 3.45 19.2V4.95001C3.45 4.12158 4.12157 3.45001 4.95 3.45001H15.7205L17.7905 1.38001C18.2505 0.931508 18.975 0.920008 19.4235 1.38001ZM12.9145 11.132L19.09 4.96801L17.457 3.33501L11.293 9.51051L10.4765 11.9485L12.9145 11.132Z"
                                        fill="white"/>
                                </svg>
                            </div>
                            <span class="">{{__('Manage Blogs')}}</span>
                        </a>
                        <div class="collapse {{@$showManageBlog}}" id="collapseBlog" data-bs-parent="#sidebarMenu">
                            <ul class="zSidebar-submenu">
                                <li><a class="{{ @$activeBlogCategoryIndex }}"
                                       href="{{route('admin.blogs.categories.index')}}">{{__('Categories')}}</a></li>
                                <li><a class="{{ @$activeBlogIndex }}"
                                       href="{{ route('admin.blogs.index') }}">{{ __('Blogs') }}</a>
                                </li>
                            </ul>
                        </div>
                    </li>
                    <li>
                        <a href="#"
                           class="d-flex align-items-center cg-10 {{isset($showPortfolio) ? 'collapsed active' : ''}}"
                           data-bs-toggle="collapse" data-bs-target="#collapsePortfolio"
                           aria-expanded="{{isset($showPortfolio) ? 'true' : 'false'}}"
                           aria-controls="collapsePortfolio">
                            <div class="d-flex">
                                <svg width="23" height="23" viewBox="0 0 23 23" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M10.65 13.2H3.85V18.3C3.85 18.7509 4.02911 19.1833 4.34792 19.5021C4.66673 19.8209 5.09913 20 5.55 20H17.45C17.9009 20 18.3333 19.8209 18.6521 19.5021C18.9709 19.1833 19.15 18.7509 19.15 18.3V13.2H12.35V14.9H10.65V13.2ZM10.65 12.35H3V7.25C3 6.315 3.765 5.55 4.7 5.55H8.1V4.7C8.1 4.24913 8.27911 3.81673 8.59792 3.49792C8.91673 3.17911 9.34913 3 9.8 3H13.2C13.6509 3 14.0833 3.17911 14.4021 3.49792C14.7209 3.81673 14.9 4.24913 14.9 4.7V5.55H18.3C18.7509 5.55 19.1833 5.72911 19.5021 6.04792C19.8209 6.36673 20 6.79913 20 7.25V12.35H12.35V10.65H10.65V12.35ZM13.2 5.55V4.7H9.8V5.55H13.2Z"
                                        fill="white"/>
                                </svg>
                            </div>
                            <span class="">{{__('Manage Portfolio')}}</span>
                        </a>
                        <div class="collapse {{@$showPortfolio}}" id="collapsePortfolio" data-bs-parent="#sidebarMenu">
                            <ul class="zSidebar-submenu">
                                <li><a class="{{ @$activePortfolioCategory }}"
                                       href="{{route('admin.theme-settings.portfolios.categories.index')}}">{{__('Categories')}}</a>
                                </li>
                                <li><a class="{{ @$activePortfolio }}"
                                       href="{{ route('admin.theme-settings.portfolios.index') }}">{{ __('Portfolio') }}</a>
                                </li>
                            </ul>
                        </div>
                    </li>
                    <li>
                        <a href="{{ route('admin.theme-settings.about-us.index') }}"
                           class="d-flex align-items-center cg-10 {{ $activeAboutUs ?? '' }}">
                            <div class="d-flex {{ isset($activeAboutUs) ? 'active' : 'collapsed' }}">
                                <svg width="23" height="23" viewBox="0 0 23 23" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M11.5 1.91675C16.7928 1.91675 21.0834 6.20733 21.0834 11.5001C21.0834 16.7928 16.7928 21.0834 11.5 21.0834C6.20731 21.0834 1.91669 16.7928 1.91669 11.5001C1.91669 6.20733 6.20731 1.91675 11.5 1.91675ZM12.4604 10.5417H10.5438V16.2917H12.4604V10.5417ZM11.5098 6.46882C10.811 6.46882 10.3042 6.97284 10.3042 7.65345C10.3042 8.3616 10.7977 8.86468 11.5098 8.86468C12.1941 8.86468 12.7 8.36155 12.7 7.66675C12.7 6.97288 12.1941 6.46882 11.5098 6.46882Z"
                                          fill="white"/>
                                </svg>
                            </div>
                            <span class="">{{ __('About Us') }}</span>
                        </a>
                    </li>
                @endcan
                @can('Manage Setting')
                    <li>
                        <a href="{{ route('admin.setting.email-template') }}"
                           class="d-flex align-items-center cg-10 {{ $activeEmailSetting ?? '' }}">
                            <div class="d-flex {{ isset($activeEmailSetting) ? 'active' : 'collapsed' }}">
                                <svg width="23" height="23" viewBox="0 0 23 23" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M18.2083 3.83325H4.79167C4.02917 3.83325 3.29791 4.13615 2.75874 4.67532C2.21957 5.21449 1.91667 5.94575 1.91667 6.70825V16.2916C1.91667 17.0541 2.21957 17.7853 2.75874 18.3245C3.29791 18.8637 4.02917 19.1666 4.79167 19.1666H18.2083C18.9708 19.1666 19.7021 18.8637 20.2413 18.3245C20.7804 17.7853 21.0833 17.0541 21.0833 16.2916V6.70825C21.0833 5.94575 20.7804 5.21449 20.2413 4.67532C19.7021 4.13615 18.9708 3.83325 18.2083 3.83325ZM18.2083 5.74992L11.9792 10.0337C11.8335 10.1178 11.6682 10.1621 11.5 10.1621C11.3318 10.1621 11.1665 10.1178 11.0208 10.0337L4.79167 5.74992H18.2083Z"
                                        fill="white"/>
                                </svg>
                            </div>
                            <span class="">{{ __('Email Template') }}</span>
                        </a>
                    </li>
                @endcan
                <li>
                    <a href="{{ route('admin.contact-us') }}"
                       class="d-flex align-items-center cg-10 {{ $activeContactUs ?? '' }}">
                        <div class="d-flex {{ isset($activeContactUs) ? 'active' : 'collapsed' }}">
                            <svg width="23" height="23" viewBox="0 0 23 23" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M4.025 4.6001C3.5675 4.6001 3.12874 4.78184 2.80524 5.10534C2.48174 5.42884 2.3 5.8676 2.3 6.3251V16.6751C2.3 17.1326 2.48174 17.5714 2.80524 17.8949C3.12874 18.2184 3.5675 18.4001 4.025 18.4001H18.975C19.4325 18.4001 19.8713 18.2184 20.1948 17.8949C20.5183 17.5714 20.7 17.1326 20.7 16.6751V6.3251C20.7 5.8676 20.5183 5.42884 20.1948 5.10534C19.8713 4.78184 19.4325 4.6001 18.975 4.6001H4.025ZM7.475 11.5001C7.0175 11.5001 6.57874 11.3184 6.25524 10.9949C5.93174 10.6714 5.75 10.2326 5.75 9.7751C5.75 9.3176 5.93174 8.87884 6.25524 8.55534C6.57874 8.23184 7.0175 8.0501 7.475 8.0501C7.9325 8.0501 8.37126 8.23184 8.69476 8.55534C9.01826 8.87884 9.2 9.3176 9.2 9.7751C9.2 10.2326 9.01826 10.6714 8.69476 10.9949C8.37126 11.3184 7.9325 11.5001 7.475 11.5001ZM5.69135 12.3626H9.2575C9.54685 12.3629 9.82426 12.478 10.0289 12.6826C10.2335 12.8872 10.3485 13.1646 10.3489 13.4539C10.3489 14.428 9.6853 15.2767 8.74 15.5136L8.67215 15.5308C7.88555 15.7263 7.06215 15.7263 6.27555 15.5308L6.20655 15.5136C5.7475 15.3985 5.34008 15.1333 5.049 14.7601C4.75792 14.3869 4.59989 13.9272 4.6 13.4539C4.60031 13.1646 4.71539 12.8872 4.91999 12.6826C5.12459 12.478 5.402 12.3629 5.69135 12.3626ZM12.65 9.7751C12.65 9.6226 12.7106 9.47634 12.8184 9.36851C12.9262 9.26068 13.0725 9.2001 13.225 9.2001H16.675C16.8275 9.2001 16.9738 9.26068 17.0816 9.36851C17.1894 9.47634 17.25 9.6226 17.25 9.7751C17.25 9.9276 17.1894 10.0739 17.0816 10.1817C16.9738 10.2895 16.8275 10.3501 16.675 10.3501H13.225C13.0725 10.3501 12.9262 10.2895 12.8184 10.1817C12.7106 10.0739 12.65 9.9276 12.65 9.7751ZM13.225 12.6501H16.675C16.8275 12.6501 16.9738 12.7107 17.0816 12.8185C17.1894 12.9263 17.25 13.0726 17.25 13.2251C17.25 13.3776 17.1894 13.5239 17.0816 13.6317C16.9738 13.7395 16.8275 13.8001 16.675 13.8001H13.225C13.0725 13.8001 12.9262 13.7395 12.8184 13.6317C12.7106 13.5239 12.65 13.3776 12.65 13.2251C12.65 13.0726 12.7106 12.9263 12.8184 12.8185C12.9262 12.7107 13.0725 12.6501 13.225 12.6501Z"
                                    fill="white"/>
                            </svg>
                        </div>
                        <span class="">{{ __('Contact Us') }}</span>
                    </a>
                </li>
                @can('Manage Setting')
                    <li>
                        <a href="{{ route('admin.setting.configuration-settings') }}"
                           class="d-flex align-items-center cg-10 {{ $activeConfigurationSetting ?? '' }}">
                            <div class="d-flex {{ isset($activeConfigurationSetting) ? 'active' : 'collapsed' }}">
                                <svg width="23" height="23" viewBox="0 0 23 23" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M10.0692 13.5527C9.81332 13.5527 9.56319 13.6286 9.35043 13.7708C9.13768 13.9129 8.97185 14.115 8.87393 14.3514C8.77601 14.5878 8.75039 14.8479 8.80031 15.0989C8.85023 15.3498 8.97345 15.5804 9.15438 15.7613C9.33532 15.9422 9.56584 16.0655 9.8168 16.1154C10.0678 16.1653 10.3279 16.1397 10.5643 16.0418C10.8007 15.9438 11.0028 15.778 11.1449 15.5653C11.2871 15.3525 11.363 15.1024 11.363 14.8465C11.363 14.5034 11.2266 14.1743 10.984 13.9317C10.7414 13.689 10.4123 13.5527 10.0692 13.5527Z"
                                        fill="white"/>
                                    <path
                                        d="M13.4167 1.92627H5.75C5.24309 1.92805 4.7576 2.13086 4.40006 2.49019C4.04252 2.84953 3.84215 3.33603 3.84291 3.84294L3.83333 19.1763C3.83257 19.6832 4.03294 20.1697 4.39048 20.529C4.74802 20.8883 5.23351 21.0912 5.74041 21.0929H17.25C17.7579 21.0914 18.2445 20.889 18.6036 20.5299C18.9627 20.1708 19.1651 19.6841 19.1667 19.1763V7.67627L13.4167 1.92627ZM14.2437 16.261L13.3812 17.7531C13.3541 17.7971 13.3129 17.8305 13.2642 17.8477C13.2156 17.865 13.1625 17.8651 13.1138 17.848L12.0357 17.4168C11.814 17.5889 11.5703 17.7307 11.3112 17.8384L11.1483 18.9779C11.1391 19.0287 11.1124 19.0746 11.0728 19.1077C11.0332 19.1408 10.9833 19.1589 10.9317 19.159H9.20671C9.15483 19.1599 9.10441 19.1419 9.06476 19.1084C9.02512 19.0749 8.99895 19.0282 8.99108 18.9769L8.82816 17.8394C8.56394 17.7355 8.31657 17.5931 8.09408 17.4168L7.02458 17.848C6.97587 17.8661 6.92232 17.8664 6.8734 17.8489C6.82448 17.8314 6.78332 17.7971 6.75721 17.7522L5.89471 16.261C5.87062 16.216 5.86262 16.1641 5.87203 16.1139C5.88144 16.0637 5.9077 16.0183 5.94646 15.985L6.86071 15.2691C6.82606 14.9885 6.82606 14.7046 6.86071 14.4239L5.94646 13.708C5.90595 13.676 5.8784 13.6304 5.86889 13.5797C5.85937 13.529 5.86855 13.4765 5.89471 13.432L6.75721 11.9399C6.78416 11.8956 6.82553 11.8619 6.87438 11.8444C6.92324 11.827 6.9766 11.8268 7.02554 11.8441L8.09408 12.2753C8.32024 12.1052 8.56646 11.9636 8.82721 11.8536L8.99108 10.7151C9.00005 10.6644 9.02653 10.6183 9.06593 10.5851C9.10533 10.5518 9.15514 10.5334 9.20671 10.5331H10.9317C10.9826 10.5325 11.0319 10.5508 11.0701 10.5844C11.1084 10.618 11.1328 10.6646 11.1387 10.7151L11.3026 11.8536C11.5664 11.9573 11.8135 12.0994 12.0357 12.2753L13.1052 11.8441C13.154 11.8257 13.2078 11.8252 13.2569 11.8428C13.3061 11.8603 13.3474 11.8947 13.3735 11.9399L14.236 13.432C14.26 13.4771 14.2679 13.5291 14.2583 13.5793C14.2487 13.6295 14.2222 13.6749 14.1833 13.708L13.2691 14.4239C13.2935 14.5631 13.3051 14.7042 13.3036 14.8456C13.2999 14.9873 13.2884 15.1287 13.2691 15.2691L14.192 15.985C14.2307 16.0183 14.257 16.0637 14.2664 16.1139C14.2758 16.1641 14.2678 16.216 14.2437 16.261ZM12.4583 8.6346V3.36377L17.7292 8.6346H12.4583Z"
                                        fill="white"/>
                                </svg>
                            </div>
                            <span class="">{{ __('App Configuration') }}</span>
                        </a>
                    </li>
                @endcan

                @if(auth()->user()->role == USER_ROLE_ADMIN)
                    <li>
                        <a href="{{ route('admin.file-version-update') }}"
                           class="{{ $activeVersionUpdate ?? '' }} d-flex align-items-center cg-10">
                            <div class="d-flex {{ $activeVersionUpdate ?? '' }}">
                                <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_953_924)">
                                        <path d="M1.88647 4.98682V10.9868H7.88647" stroke="white" stroke-opacity="0.7"
                                              stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M23.8865 20.9868V14.9868H17.8865" stroke="white" stroke-opacity="0.7"
                                              stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path
                                            d="M21.3765 9.98689C20.8693 8.55368 20.0073 7.27229 18.871 6.26231C17.7347 5.25233 16.361 4.54666 14.8782 4.21115C13.3954 3.87564 11.8517 3.92123 10.3913 4.34367C8.93085 4.7661 7.60122 5.55161 6.52647 6.62689L1.88647 10.9869M23.8865 14.9869L19.2465 19.3469C18.1717 20.4222 16.8421 21.2077 15.3817 21.6301C13.9212 22.0526 12.3776 22.0981 10.8948 21.7626C9.41194 21.4271 8.03827 20.7215 6.90194 19.7115C5.76561 18.7015 4.90364 17.4201 4.39647 15.9869"
                                            stroke="white" stroke-opacity="0.7" stroke-width="2" stroke-linecap="round"
                                            stroke-linejoin="round"/>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_953_924">
                                            <rect width="24" height="24" fill="white"
                                                  transform="translate(0.886475 0.986816)"/>
                                        </clipPath>
                                    </defs>
                                </svg>

                            </div>
                            <span class="">{{ __('Version Update') }}</span>
                        </a>
                    </li>
                @endif
            </ul>
            <a href="{{ route('logout') }}" class="d-inline-flex align-items-center cg-15 pt-17 pb-30 px-25">
                <img src="{{ asset('assets/images/icon/logout.svg') }}" alt=""/>
                <p class="fs-15 fw-500 lh-18 text-para-text">{{ __('Logout') }}</p>
            </a>
        </div>
    </div>
</div>
